﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;

namespace PowerAmpDemoNS
{
    public partial class PowerAmpDemoProgram
    {
        // Test Procedures
        public int cwTest()
        {
            // Configure variables for WCDMA Standard
            string testWaveform = cwArb; // powerRampArb;
            string etWaveform = powerRampArb;
            string testName = "CW Test";
            vsag.setupParameters("CW");
            dataLog.tstName = "CW";

            dataLog.addResultsHeader(testName);
            //Start Test timer
            sw.Reset();
            sw.Start();

            // Configure for External Trigger on ARB Wrap signal
            vsag.configVsaTrigger("EXTERNAL");

            // Configuration for ET:
            // 1.  Stop RF AWG Playback
            // 2.  Start ET AWG playback with External Trigger
            // 3.  Start RF AWG on 10 MHz clock edge using Baseband Delay to adjust timing
            vsag.stopModulation();
            if (etArb.use33522B)
            {
                arbAmplitude = 0.6;
                arbOffset = 0.44;
            }
            etArb.startAwgWaveformTriggered(powerRampArb + ".csv", arbAmplitude, arbOffset, 0.0);
            // Setup the VSG and VSA for waveform, band frequency and power level
            vsag.setVsgIqDelay(iqDelay);
            // Setup the VSG and VSA for waveform, band frequency and power level
            vsag.setupVsgVsa(testWaveform, cellFreqs[0], targetPout, targetGain);

            // Loop over Frequencies for Low Band
            for (int i = 0; i < cellFreqs.Length; i++)
            {
                dataLog.addResultsHeader("Frequency = " + (cellFreqs[i] / 1e6).ToString("0.0") +
                    " MHz, Output Power = " + targetPout.ToString("0.00") + " dBm");
                // Set VSG and VSA to test frequency
                vsag.setTestFreq(cellFreqs[i]);

                // Servo source until Pout is at correct value
                if (vsag.fftServo)
                    vsag.servoInputPowerFft(targetPout, poutMargin);
                else
                    vsag.servoInputPower(targetPout, poutMargin);

                if (testCompression)
                {
                    // Measure ACPR
                    vsag.measGainComp(100e-6, -30);
                    //Lib.iqDataTo89600File(200e-6, "IQ_Data_" + (cellFreqs[i]/1e6).ToString("0.0")+ "_MHz_" + Lib.M9381.RF.Level.ToString("0.0") +"_dBm.txt");
                }

                // Tests complete, setup for next test
                dataLog.nextTest();
            }
            // Put it back to immediate trigger
            vsag.configVsaTrigger("IMMEDIATE");

            // Update results and data log for end of test
            dataLog.addResultsFooter(testName, sw.ElapsedMilliseconds);
            return 0;
        }
    }
}